package coreservlets;

import javax.servlet.*;
import javax.servlet.http.*;

/** Kilka uytecznych dodatkw. Wikszo z nich to metody statyczne.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class ServletUtilities {
  public static final String DOCTYPE =
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
    "Transitional//EN\">";

  public static String headWithTitle(String title) {
    return(DOCTYPE + "\n" +
           "<HTML>\n" +
           "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n");
  }

  /** Odczytanie parametru o wskazanej nazwie, przeksztacenie
   *  go do wartoci typu int i zwrcenie. Jeeli parametr nie istnieje
   *  albo ma format nieprawidowy dla typu int, zwrcona
   *  zostaje z gry zdefiniowana warto domylna.
  */

  public static int getIntParameter(HttpServletRequest request,
                                    String paramName,
                                    int defaultValue) {
    String paramString = request.getParameter(paramName);
    int paramValue;
    try {
      paramValue = Integer.parseInt(paramString);
    } catch(NumberFormatException nfe) { // null albo zy format
      paramValue = defaultValue;
    }
    return(paramValue);
  }

  public static double getDoubleParameter
                                 (HttpServletRequest request,
                                  String paramName,
                                  double defaultValue) {
    String paramString = request.getParameter(paramName);
    double paramValue;
    try {
      paramValue = Double.parseDouble(paramString);
    } catch(NumberFormatException nfe) { // null or bad format
      paramValue = defaultValue;
    }
    return(paramValue);
  }

  /** Zastpienie znakw, ktre maj w HTML-u specjalne znaczenie,
   *  odpowiadajcymi im znakowymi elementami jzyka HTML.
   */

  // Javadoc nie jest uywany do sporzdzania bardziej szczegowej
  // dokumentacji, poniewa trudno jest uczyni znaki specjalne
  // czytelnymi zarwno w zwykym tekcie, jak i w HTML-u.
  //
  // W danym cigu znakw ponisza metoda zastpuje wszystkie
  // wystpienia '<' sekwencj '&lt;', wszystkie wystpienia '>'
  // sekwencj '&gt;', wszystkie wystpienia cudzysoww sekwencj
  // '&quot;' (w celu obsuenia wystpie wewntrz atrybutw)
  // oraz wszystkie wystpienia '&' sekwencj '&amp;'.
  // Bez filtrowania w tak zdefiniowany sposb, cigu znakw nie mona by
  // bezpieczenie umieszcza w kodzie strony internetowej.

  public static String filter(String input) {
    if (!hasSpecialChars(input)) {
      return(input);
    }
    StringBuffer filtered = new StringBuffer(input.length());
    char c;
    for(int i=0; i<input.length(); i++) {
      c = input.charAt(i);
      switch(c) {
        case '<': filtered.append("&lt;"); break;
        case '>': filtered.append("&gt;"); break;
        case '"': filtered.append("&quot;"); break;
        case '&': filtered.append("&amp;"); break;
        default: filtered.append(c);
      }
    }
    return(filtered.toString());
  }

  private static boolean hasSpecialChars(String input) {
    boolean flag = false;
    if ((input != null) && (input.length() > 0)) {
      char c;
      for(int i=0; i<input.length(); i++) {
        c = input.charAt(i);
        switch(c) {
          case '<': flag = true; break;
          case '>': flag = true; break;
          case '"': flag = true; break;
          case '&': flag = true; break;
        }
      }
    }
    return(flag);
  }
}
